/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.GrammarEditorShell;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import net.nooj4nlp.controller.GrammarEditorShell.GrammarEditorShellController;
import net.nooj4nlp.engine.Graph;
import net.nooj4nlp.engine.RefObject;
import net.nooj4nlp.gui.shells.GrammarEditorShell;

public class TextBoxKeyListener
implements KeyListener {
    private GrammarEditorShell editor;
    private GrammarEditorShellController controller;

    public TextBoxKeyListener(GrammarEditorShell shell) {
        this.editor = shell;
        this.controller = this.editor.getController();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.editor.rtBox.getWidth() == 0) {
            return;
        }
        if (e.getKeyCode() == 10 && (e.isControlDown() || e.isAltDown())) {
            this.controller.grf.label.set(this.controller.mouseEdited, this.controller.cleanup(this.editor.rtBox.getText()));
            if (this.controller.grf.label.get(this.controller.mouseEdited).equals("")) {
                if (this.controller.mouseEdited == 0) {
                    this.controller.grf.label.set(this.controller.mouseEdited, "<E>");
                } else if (this.controller.mouseEdited > 1) {
                    this.controller.grf.deleteNode(this.controller.mouseEdited);
                }
            }
            this.controller.modify("edit node #" + this.controller.mouseEdited, false, true);
            this.controller.hideRtbox();
        } else if (e.getKeyCode() == 27) {
            this.controller.hideRtbox();
        } else {
            if (this.editor.rtBox.getText().equals("")) {
                int height = this.controller.grf.interline * 1 + 10;
                int width = 5 * this.controller.grf.ifont.getSize();
                if (this.editor.rtBox.getWidth() < 50) {
                    width = 50;
                }
                this.editor.rtBox.setSize(width, height);
                return;
            }
            String output = null;
            int height = this.controller.grf.interline * (this.editor.rtBox.getLineCount() + 1) + 10;
            this.controller.grf.label.set(this.controller.mouseEdited, this.controller.cleanup(this.editor.rtBox.getText()));
            RefObject<Object> outputRef = new RefObject<Object>(output);
            String[] terms = Graph.inLineLabel(this.controller.grf.label.get(this.controller.mouseEdited), outputRef);
            output = (String)outputRef.argvalue;
            int maxlen = 0;
            if (this.editor.getGraphics() != null) {
                for (int it = 0; it < terms.length; ++it) {
                    int len = terms[it].length() * this.controller.grf.ifont.getSize();
                    if (len <= maxlen) continue;
                    maxlen = len;
                }
            }
            if (maxlen < this.controller.grf.widB.get(this.controller.mouseEdited)) {
                maxlen = this.controller.grf.widB.get(this.controller.mouseEdited);
            }
            if (maxlen < 50) {
                maxlen = 50;
            }
            int width = maxlen;
            this.editor.rtBox.setSize(width, height);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

